package jamezo97.clonecraft.item;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.Reflect;
import jamezo97.clonecraft.dna.Gene;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemEntitySequencePaper extends Item{

	public ItemEntitySequencePaper(int par1) {
		super(par1);
		this.setHasSubtypes(true);
		this.setTextureName("clonecraft:sequencePaper");
	}



	@Override
	public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
		Random rand = new Random(par1ItemStack.getItemDamage());
		return 0xff000000 | ((int)(rand.nextFloat()*185 + 70) << 16) | ((int)(rand.nextFloat()*185 + 70) << 8) | ((int)(rand.nextFloat()*185 + 70));
	}



	@Override
	public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
		ArrayList<Integer> genes = entityIdToGene.get(stack.getItemDamage());
		if(genes != null){
			for(int a = 0; a < genes.size(); a++){
				Gene gene = Gene.getGene(genes.get(a));
				if(gene != null){
					list.add("\247" + CloneCraftUtils.getClosestColourChar(gene.getColour()) + gene.getName() + " \247fGene");
				}
			}
		}
	}

	@Override
	public String getItemDisplayName(ItemStack stack) {
		String name = getEntityName(stack.getItemDamage());
		if(name != null){
			return name + " DNA Data";
		}
		return super.getItemDisplayName(stack);
	}

	public String getEntityName(int id){
		if(id == CloneCraft.cloneId){
			return "Human";
		}
		return EntityList.getStringFromID(id);
	}

	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List list) {
		updateMapping();
		for(Iterator<Entry<Integer, ArrayList<Integer>>> it = entityIdToGene.entrySet().iterator(); it.hasNext();){
			Entry<Integer, ArrayList<Integer>> entry = it.next();
			list.add(new ItemStack(this.itemID, 1, entry.getKey()));
		}


	}

	public static HashMap<Integer, ArrayList<Integer>> entityIdToGene = new HashMap<Integer, ArrayList<Integer>>();

	static{
		updateMapping();
	}

	public static void updateMapping(){
		Map map = Reflect.get(null, Reflect.classToIDMapping, Map.class);

		if((map != null && map instanceof HashMap)){
			HashMap<?, ?> classToIDMapping = (HashMap<?, ?>)map;
			int[] geneIds = Gene.getAllGeneIds();
			for(int a = 0; a < geneIds.length; a++){
				Gene gene = Gene.getGene(geneIds[a]);
				Class[] applicableEntities = gene.getEntityClassesWithGene();
				if(applicableEntities == null)continue;
				for(int b = 0; b < applicableEntities.length; b++){
					Object eId = classToIDMapping.get(applicableEntities[b]);
					if(eId != null && eId instanceof Integer){
						int entityId = (Integer)eId;
						ArrayList<Integer> geneArray = null;
						if(!entityIdToGene.containsKey(entityId)){
							entityIdToGene.put(entityId, geneArray = new ArrayList<Integer>());
						}else{
							geneArray = entityIdToGene.get(entityId);
						}
						if(!geneArray.contains(gene.getId())){
							geneArray.add(gene.getId());
						}
					}else{
						Logger.error("classToIDMapping does not contains mapping for class " + applicableEntities[b]);
					}

				}
			}
		}else{
			Logger.error("ClassToIDMapping could not be loaded. DNA Sequence Papers will not be implemented.");

		}
	}




}
